/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.api;

import filenet.vw.base.logging.Logger;
import filenet.ws.api.IWSTypeEntry;
import filenet.ws.api.WSDefinedElement;
import filenet.ws.api.WSDefinition;
import filenet.ws.api.WSDefinitionBuilder;
import filenet.ws.api.WSElementDecl;
import filenet.ws.api.WSMessage;
import filenet.ws.api.WSType;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import javax.wsdl.Types;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WSXMLSchema {
    protected static Logger logger = Logger.getLogger("filenet.ws.api");
    protected static String m_className = "filenet.ws.api.WSXMLSchema";
    static String s_targetNamespace = "targetNamespace";
    static String s_xmlns = "xmlns";
    static String s_xmlnsPrefix = "xmlns:";
    static String s_xsdSchema = "xsd:schema";
    static String s_XMLSchmea = "XMLSchema";
    static String s_schema = "Schema";
    private WSDefinition m_definition = null;
    private Element m_root = null;
    private Document m_doc = null;
    private Element m_schema = null;
    private SchemaNode[] m_schemaNodes = null;
    private String m_targetNamespace = null;
    private Hashtable m_namespaces = null;
    private Hashtable m_attributes = null;
    private Hashtable m_requiredNamespaces = new Hashtable();

    public static String _get_FILE_DATE() {
        return "$Date:   10 Sep 2008 10:03:48  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   ysoong  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.15  $";
    }

    public static String[] getSchemaElements(String schema) throws Exception {
        String[] elements;
        block2: {
            String m_method = "getSchemaElements";
            WSDefinitionBuilder defBuilder = new WSDefinitionBuilder("test", "anyTargetNamespace", null);
            defBuilder.addSchema("aSchema", schema);
            elements = defBuilder.getElementNames("aSchema");
            try {
                defBuilder.releaseWSDefinitionReferences();
                defBuilder.releaseReferences();
                defBuilder = null;
            }
            catch (Exception ex) {
                if (!logger.isFinest()) break block2;
                logger.throwing(m_className, m_method, ex);
            }
        }
        return elements;
    }

    public static String getXMLTemplate(String schemaName, String schema, String element) throws Exception {
        String s;
        block2: {
            String m_method = "getXMLTemplate";
            WSDefinitionBuilder defBuilder = new WSDefinitionBuilder("test", "anyTargetNamespace", null);
            defBuilder.addSchema(schemaName, schema);
            defBuilder.addMessage("aMessage", schemaName, element);
            WSDefinition wsDef = defBuilder.getWSDefinition();
            WSMessage msg = wsDef.getMessage(new QName("anyTargetNamespace", "aMessage"));
            s = msg.getXMLMessageTemplate();
            try {
                msg.releaseReferences();
                msg = null;
                wsDef.releaseReferences();
                wsDef = null;
                defBuilder.releaseWSDefinitionReferences();
                defBuilder.releaseReferences();
                defBuilder = null;
            }
            catch (Exception ex) {
                if (!logger.isFinest()) break block2;
                logger.throwing(m_className, m_method, ex);
            }
        }
        return s;
    }

    public static String getExpressionTemplate(String schemaName, String schema, String element) throws Exception {
        String s;
        block2: {
            WSDefinitionBuilder defBuilder = new WSDefinitionBuilder("test", "anyTargetNamespace", null);
            defBuilder.addSchema(schemaName, schema);
            defBuilder.addMessage("aMessage", schemaName, element);
            WSDefinition wsDef = defBuilder.getWSDefinition();
            WSMessage msg = wsDef.getMessage(new QName("anyTargetNamespace", "aMessage"));
            s = msg.getExpressionMessageTemplate();
            try {
                msg.releaseReferences();
                msg = null;
                wsDef.releaseReferences();
                wsDef = null;
                defBuilder.releaseReferences();
                defBuilder = null;
            }
            catch (Exception ex) {
                if (!logger.isFinest()) break block2;
                logger.throwing(m_className, "getExpressionTemplate", ex);
            }
        }
        return s;
    }

    public WSXMLSchema(WSDefinition definition) {
        this.m_definition = definition;
        if (definition != null) {
            Types types;
            List list;
            this.m_targetNamespace = definition.getTargetNameSpace();
            if (this.m_targetNamespace != null) {
                if (this.m_targetNamespace.lastIndexOf("/") != this.m_targetNamespace.length() - 1) {
                    this.m_targetNamespace = this.m_targetNamespace + "/";
                }
                this.m_targetNamespace = this.m_targetNamespace + s_XMLSchmea;
            }
            if ((list = (types = definition.getDefinition().getTypes()).getExtensibilityElements()) == null) {
                return;
            }
            ListIterator iterator = list.listIterator();
            Object obj = null;
            Vector<SchemaNode> schemaNodeVector = new Vector<SchemaNode>();
            while (iterator.hasNext()) {
                obj = iterator.next();
                if (obj == null || !(obj instanceof UnknownExtensibilityElement)) continue;
                UnknownExtensibilityElement extElt = obj;
                System.out.println(extElt.getElementType());
                Element elt = extElt.getElement();
                if (elt.getNodeName() == null || elt.getLocalName().compareTo("schema") != 0) continue;
                schemaNodeVector.add(new SchemaNode(elt));
            }
            if (schemaNodeVector != null && schemaNodeVector.size() > 0) {
                this.m_schemaNodes = new SchemaNode[schemaNodeVector.size()];
                schemaNodeVector.toArray(this.m_schemaNodes);
                schemaNodeVector.removeAllElements();
            }
            this.consolidateAttributesAndNamespaces();
            Enumeration enum1 = this.m_namespaces.keys();
            while (enum1.hasMoreElements()) {
                obj = enum1.nextElement();
                System.out.println(obj + " : " + this.m_namespaces.get(obj));
            }
            enum1 = this.m_attributes.keys();
            while (enum1.hasMoreElements()) {
                obj = enum1.nextElement();
                System.out.println(obj + " : " + this.m_attributes.get(obj));
            }
        }
    }

    public String getMessageSchema(WSMessage[] messages) throws Exception {
        return null;
    }

    public String getMessageSchema(WSMessage message) throws Exception {
        return null;
    }

    private void addToSchema(WSDefinedElement element) {
        IWSTypeEntry typeEntry;
        String elementName = element.getName();
        Node elementNode = element.getDefinedElement().getNode();
        NodeList nodeList = this.m_schema.getElementsByTagName(elementNode.getNodeName());
        boolean bFound = false;
        if (nodeList != null && nodeList.getLength() > 0) {
            NamedNodeMap attributes = null;
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String nodeName;
                Node attr;
                if (nodeList.item(i) == null || (attributes = nodeList.item(i).getAttributes()) == null || (attr = attributes.getNamedItem("name")) == null || (nodeName = attr.getNodeValue()) == null || nodeName.compareTo(elementName) != 0) continue;
                bFound = true;
                break;
            }
        }
        if (!bFound) {
            this.addNamespacesToSchema(elementNode);
            Node importedNode = this.m_doc.importNode(elementNode, true);
            this.m_schema.appendChild(importedNode);
        }
        if ((typeEntry = element.getRefTypeEntry()) != null) {
            if (typeEntry instanceof WSDefinedElement) {
                this.addToSchema((WSDefinedElement)typeEntry);
            } else if (typeEntry instanceof WSType) {
                this.addToSchema((WSType)typeEntry);
            }
        }
    }

    private void addToSchema(WSType type) {
        if (type == null || this.m_doc == null || this.m_schema == null) {
            return;
        }
        if (!type.isBaseType()) {
            Node typeNode = type.getType().getNode();
            String typeName = null;
            if (typeNode != null && typeNode instanceof Element) {
                typeName = ((Element)typeNode).getAttribute("name");
            }
            if (typeName != null && typeName.length() > 0) {
                WSElementDecl[] elementDecls;
                String typeNodeName = typeNode.getNodeName();
                if (typeNodeName != null && typeNodeName.indexOf("element") != -1 && type.getRefType() != null) {
                    this.addToSchema(type.getRefType());
                    return;
                }
                NodeList nodeList = this.m_schema.getElementsByTagName(typeNode.getNodeName());
                boolean bFound = false;
                NamedNodeMap attributes = null;
                if (nodeList != null && nodeList.getLength() > 0) {
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        String nodeName;
                        Node attr;
                        if (nodeList.item(i) == null || (attributes = nodeList.item(i).getAttributes()) == null || (attr = attributes.getNamedItem("name")) == null || (nodeName = attr.getNodeValue()) == null || nodeName.compareTo(typeName) != 0) continue;
                        bFound = true;
                        break;
                    }
                }
                if (!bFound) {
                    this.addNamespacesToSchema(typeNode);
                    Node importedNode = this.m_doc.importNode(typeNode, true);
                    this.m_schema.appendChild(importedNode);
                }
                if ((elementDecls = type.getElementDecls()) != null) {
                    for (int i = 0; i < elementDecls.length; ++i) {
                        if (elementDecls[i] == null) continue;
                        this.addToSchema(elementDecls[i]);
                    }
                }
                if (type.getRefType() != null) {
                    this.addToSchema(type.getRefType());
                }
            }
        }
    }

    private void addToSchema(WSElementDecl element) {
        if (element.getType() != null) {
            this.addToSchema(element.getType());
        }
    }

    private void addNamespacesToSchema() {
        if (this.m_schema != null) {
            String value;
            String name;
            Object obj;
            Enumeration enum1;
            if (this.m_targetNamespace != null) {
                this.m_schema.setAttribute(s_targetNamespace, this.m_targetNamespace);
            }
            if (this.m_attributes != null) {
                enum1 = this.m_attributes.keys();
                obj = null;
                name = null;
                value = null;
                if (enum1 != null) {
                    while (enum1.hasMoreElements()) {
                        obj = enum1.nextElement();
                        if (obj == null || !(obj instanceof String) || (obj = this.m_attributes.get(name = (String)obj)) == null || !(obj instanceof String)) continue;
                        value = obj;
                        this.m_schema.setAttribute(name, value);
                    }
                }
            }
            if (this.m_requiredNamespaces != null) {
                enum1 = this.m_requiredNamespaces.keys();
                obj = null;
                name = null;
                value = null;
                if (enum1 != null) {
                    while (enum1.hasMoreElements()) {
                        obj = enum1.nextElement();
                        if (obj == null || !(obj instanceof String)) continue;
                        name = s_xmlnsPrefix + (String)obj;
                        if ((obj = this.m_requiredNamespaces.get(obj)) == null || !(obj instanceof String)) continue;
                        value = obj;
                        this.m_schema.setAttribute(name, value);
                    }
                }
            }
        }
    }

    private void addToRequiredNamespaceList(String s, SchemaNode schemaNode) {
        int index = s.indexOf(":");
        if (index != -1) {
            String namespaceURI;
            Object obj;
            String namespacePrefix = s.substring(0, index);
            if (namespacePrefix.compareTo((String)(obj = this.m_namespaces.get(namespaceURI = schemaNode.getNamespace(namespacePrefix)))) != 0) {
                System.out.println("Problem adding namespace to schema - " + namespaceURI);
                System.out.println("Prefix conflict - " + namespacePrefix + " : " + obj);
            } else {
                this.m_requiredNamespaces.put(namespacePrefix, namespaceURI);
            }
        }
    }

    private void addNamespacesToSchema(Node node) {
        this.addNamespacesToSchema(node, null);
    }

    private void addNamespacesToSchema(Node node, SchemaNode schemaNode) {
        NodeList list;
        NamedNodeMap attributes;
        int index;
        if (node == null) {
            return;
        }
        if (schemaNode == null) {
            schemaNode = this.getSchema(node);
        }
        if (schemaNode == null) {
            return;
        }
        String name = node.getNodeName();
        String value = node.getNodeValue();
        Object attribNode = null;
        String origNamespaceURI = null;
        String origNamespacePrefix = null;
        String newNamespaceURI = null;
        String newNamespacePrefix = null;
        if (name != null && (index = name.indexOf(":")) != -1) {
            origNamespacePrefix = name.substring(0, index);
            origNamespaceURI = schemaNode.getNamespace(origNamespacePrefix);
            if (origNamespaceURI == null && (origNamespaceURI = this.m_definition.getNamespace(origNamespacePrefix)) != null) {
                this.m_namespaces.put(origNamespaceURI, origNamespacePrefix);
            }
            if ((newNamespacePrefix = (String)this.m_namespaces.get(newNamespaceURI = this.isATargetNamespace(origNamespaceURI) ? this.m_targetNamespace : origNamespaceURI)) != null) {
                if (newNamespacePrefix.compareTo(origNamespacePrefix) != 0) {
                    node.setPrefix(newNamespacePrefix);
                }
                if (!this.m_requiredNamespaces.containsKey(newNamespacePrefix)) {
                    this.m_requiredNamespaces.put(newNamespacePrefix, newNamespaceURI);
                }
            } else {
                System.out.println("NodeName - Problem adding namespace to schema - " + origNamespaceURI);
                System.out.println("Prefix conflict - " + origNamespacePrefix + " : " + newNamespacePrefix);
            }
        }
        if (value != null && (index = value.indexOf(":")) != -1) {
            origNamespacePrefix = value.substring(0, index);
            origNamespaceURI = schemaNode.getNamespace(origNamespacePrefix);
            if (origNamespaceURI == null) {
                origNamespaceURI = this.m_definition.getNamespace(origNamespacePrefix);
                if (origNamespaceURI != null) {
                    this.m_namespaces.put(origNamespaceURI, origNamespacePrefix);
                } else if (origNamespacePrefix.compareTo("tns") == 0) {
                    origNamespaceURI = this.m_definition.getTargetNameSpace();
                }
            }
            if ((newNamespacePrefix = (String)this.m_namespaces.get(newNamespaceURI = this.isATargetNamespace(origNamespaceURI) ? this.m_targetNamespace : origNamespaceURI)) != null) {
                if (newNamespacePrefix.compareTo(origNamespacePrefix) != 0 && value.startsWith(origNamespacePrefix + ":")) {
                    node.setNodeValue(newNamespacePrefix + ":" + value.substring(origNamespacePrefix.length() + 1));
                }
                if (!this.m_requiredNamespaces.containsKey(newNamespacePrefix)) {
                    this.m_requiredNamespaces.put(newNamespacePrefix, newNamespaceURI);
                }
            } else {
                System.out.println("NodeValue - Problem adding namespace to schema - " + origNamespaceURI);
                System.out.println("Prefix conflict - " + origNamespacePrefix + " : " + newNamespacePrefix);
            }
        }
        if ((attributes = node.getAttributes()) != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                this.addNamespacesToSchema(attributes.item(i), schemaNode);
            }
        }
        if ((list = node.getChildNodes()) != null) {
            for (int i = 0; i < list.getLength(); ++i) {
                this.addNamespacesToSchema(list.item(i), schemaNode);
            }
        }
    }

    private boolean isATargetNamespace(String namespaceURI) {
        if (this.m_schemaNodes != null) {
            for (int i = 0; i < this.m_schemaNodes.length; ++i) {
                if (this.m_schemaNodes[i] == null || !this.m_schemaNodes[i].isTargetNamespace(namespaceURI)) continue;
                return true;
            }
        }
        return false;
    }

    private SchemaNode getSchema(Node node) {
        if (this.m_schemaNodes != null) {
            for (int i = 0; i < this.m_schemaNodes.length; ++i) {
                if (this.m_schemaNodes[i] == null || !this.m_schemaNodes[i].isFromThisSchema(node)) continue;
                return this.m_schemaNodes[i];
            }
        }
        return null;
    }

    private String getNamespacePrefix(String namespace) {
        String prefix = this.m_definition.getNamespacePrefix(namespace);
        if (prefix == null) {
            prefix = (String)this.m_namespaces.get(namespace);
        }
        return prefix;
    }

    private void consolidateAttributesAndNamespaces() {
        if (this.m_schemaNodes == null) {
            return;
        }
        SchemaNode schema = null;
        Hashtable namesapces = null;
        Hashtable attributes = null;
        Object obj = null;
        String prefix = null;
        String namespace = null;
        this.m_namespaces = new Hashtable();
        this.m_namespaces.put(this.m_targetNamespace, "tns");
        this.m_attributes = new Hashtable();
        this.m_attributes.put("targetNamespace", this.m_targetNamespace);
        for (int i = 0; i < this.m_schemaNodes.length; ++i) {
            schema = this.m_schemaNodes[i];
            if (schema == null) continue;
            namesapces = schema.getNamespaces();
            Enumeration enum1 = namesapces.keys();
            while (enum1.hasMoreElements()) {
                obj = enum1.nextElement();
                if (obj == null || !(obj instanceof String) || (prefix = (String)obj).compareTo("tns") == 0 || (obj = namesapces.get(prefix)) == null || !(obj instanceof String) || schema.isTargetNamespace(namespace = (String)obj) || this.m_namespaces.containsKey(namespace)) continue;
                this.m_namespaces.put(namespace, prefix);
            }
            String name = null;
            attributes = schema.getAttributes();
            enum1 = attributes.keys();
            while (enum1.hasMoreElements()) {
                obj = enum1.nextElement();
                if (obj == null || !(obj instanceof String) || this.m_attributes.containsKey(name = (String)obj) || (obj = attributes.get(name)) == null || !(obj instanceof String)) continue;
                this.m_attributes.put(name, obj);
            }
        }
    }

    public class SchemaNode {
        Node m_schemaNode = null;
        String m_targetNamespace = null;
        Hashtable m_attributes = new Hashtable();
        Hashtable m_namespaces = new Hashtable();
        Hashtable m_requiredNamespaces = new Hashtable();
        Hashtable m_namespacePrefixReplacement = new Hashtable();

        SchemaNode(Node node) {
            NamedNodeMap attribMap;
            this.m_schemaNode = node;
            if (this.m_schemaNode != null && (attribMap = this.m_schemaNode.getAttributes()) != null && attribMap.getLength() > 0) {
                Node aNode = null;
                String name = null;
                String value = null;
                for (int i = 0; i < attribMap.getLength(); ++i) {
                    aNode = attribMap.item(i);
                    if (aNode == null) continue;
                    name = aNode.getNodeName();
                    value = aNode.getNodeValue();
                    int index = -1;
                    if (name == null || value == null) continue;
                    if (name.compareTo(s_targetNamespace) == 0) {
                        this.m_targetNamespace = value;
                        continue;
                    }
                    index = name.indexOf(s_xmlnsPrefix);
                    if (index != -1) {
                        if (name.length() <= index) continue;
                        this.m_namespaces.put(name.substring(index + s_xmlnsPrefix.length()), value);
                        continue;
                    }
                    this.m_attributes.put(aNode.getNodeName(), aNode.getNodeValue());
                }
            }
        }

        boolean isSchemaNode(Node node) {
            String localName = node.getLocalName();
            return localName != null && localName.compareTo("schema") == 0;
        }

        boolean isFromThisSchema(Node node) {
            Node aNode = null;
            do {
                if ((aNode = node.getParentNode()) != null && this.isSchemaNode(aNode)) {
                    return aNode == this.m_schemaNode;
                }
                node = aNode;
            } while (aNode != null);
            return false;
        }

        String getNamespace(String prefix) {
            if (prefix != null) {
                String namespaceURI = (String)this.m_namespaces.get(prefix);
                if (namespaceURI == null) {
                    String newPrefix = (String)this.m_namespacePrefixReplacement.get(prefix);
                    if (newPrefix != null) {
                        return (String)this.m_namespaces.get(newPrefix);
                    }
                } else {
                    return namespaceURI;
                }
            }
            return null;
        }

        boolean isTargetNamespace(String namespace) {
            if (namespace != null && this.m_targetNamespace != null) {
                return namespace.compareTo(this.m_targetNamespace) == 0;
            }
            return false;
        }

        boolean isTargetNamespacePrefix(String prefix) {
            if (prefix != null) {
                return this.isTargetNamespace((String)this.m_namespaces.get(prefix));
            }
            return false;
        }

        void addToReqiredNamespaceList(String prefix) {
            if (prefix == null || this.m_requiredNamespaces.get(prefix) != null) {
                return;
            }
            String namespace = this.getNamespace(prefix);
            if (namespace != null) {
                this.m_requiredNamespaces.put(prefix, namespace);
            }
        }

        Hashtable getNamespaces() {
            return this.m_namespaces;
        }

        Hashtable getAttributes() {
            return this.m_attributes;
        }

        void replaceNSPrefix(String origNSPrefix, String replacement) {
            this.m_namespacePrefixReplacement.put(replacement, origNSPrefix);
        }
    }
}

